package com.global.demo;

import com.alibaba.fastjson.JSONObject;
import com.global.utils.HttpClient;
import com.global.utils.Md5;
import com.global.utils.RsaUtil;
import com.global.utils.StringUtil;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;

/**
 * 仅供测试
 *
 */
public class createOrderforRsaDemo {




        //测试号
		private String merno = "";
		private String md5key = "";
		//商户私钥
		private String priKey = "";
		//平台公钥
		private String acqPubKey = "";
        //支付网关
        private String prePayDomain = "";
        //代付网关
		private String PreWithdrawDomain = "";

      


        /*
        * 支付下单
        * */
        @Test
        public void orderPay() throws Exception {

            JSONObject jsonObject = new JSONObject();
            //设置json数据
//            jsonObject.put("bankCode","BT");//印尼固定BT
            jsonObject.put("mer_no",merno);//商户号
            jsonObject.put("pname","zhangsan");//名字（可固定）
            jsonObject.put("pemail","test@gmail.com");//邮箱（可固定）
            jsonObject.put("phone","9124512345");//手机号（可固定）
            jsonObject.put("order_amount", "100");//订单金额
            jsonObject.put("notifyUrl","https://google.com");//通知地址
            jsonObject.put("pageUrl","https://google.com");//同步跳转地址
            jsonObject.put("ccy_no","");//币种
            jsonObject.put("busi_code", "");//支付类型编码
            jsonObject.put("mer_order_no",System.currentTimeMillis());//商户订单号

            String toSign = StringUtil.buildSignSrc(jsonObject);

            jsonObject.put("sign", RsaUtil.encryptByPrivate(toSign,priKey));



            String resParam = HttpClient.doPost(prePayDomain+"/ty/orderPay",jsonObject.toJSONString());

            System.out.println(resParam);
        }

        /*
         * 代付下单
         * */
        @Test
        public void singlePay()throws Exception{
            JSONObject jsonObject = new JSONObject();
            //设置json数据
            jsonObject.put("bank_code", "");
            jsonObject.put("mer_no", merno);
            jsonObject.put("summary", "summary");
            jsonObject.put("acc_name","ZhangSAN");
            jsonObject.put("mobile_no","8778866216");
            jsonObject.put("order_amount",new BigDecimal("10"));
            jsonObject.put("acc_no","");
            jsonObject.put("ccy_no","");
            jsonObject.put("province","");//印度ifsc编码
//            jsonObject.put("identity_type","CPF");//巴西参数
            jsonObject.put("notifyUrl", "https://google.com");
            jsonObject.put("mer_order_no",System.currentTimeMillis()+"");

            String toSign = StringUtil.buildSignSrc( jsonObject);


            jsonObject.put("sign", RsaUtil.encryptByPrivate(toSign,priKey));


            String resParam = HttpClient.doPost(PreWithdrawDomain+"/withdraw/singleOrder",jsonObject.toJSONString());
            System.out.println(resParam);
        }

        /*
         * 支付查询
         * */
        @Test
        public void orderPayQuery() throws Exception {
            JSONObject jsonObject = new JSONObject();
            //设置json数据
            jsonObject.put("mer_no",merno);
            jsonObject.put("mer_order_no","");
            jsonObject.put("order_no", "");
            jsonObject.put("request_no",System.currentTimeMillis()+"");
            jsonObject.put("request_time",new SimpleDateFormat("yyyyMMddHHmmss").format(System.currentTimeMillis()-60*60*1000));

            String toSign = StringUtil.buildSignSrc( jsonObject);
            jsonObject.put("sign", Md5.md5Str(toSign+"&key="+md5key));

            String resParam = HttpClient.doPost(prePayDomain+"/ty/orderQuery", jsonObject.toJSONString());

            System.out.println(resParam);
        }

        /*
         * 代付查询
         * */
        @Test
        public void withdPayQuery() throws Exception {
            JSONObject jsonObject = new JSONObject();
            //设置json数据
            jsonObject.put("mer_no",merno);
            jsonObject.put("mer_order_no","");
            jsonObject.put("order_no", "");
            jsonObject.put("request_no",System.currentTimeMillis()+"");
            jsonObject.put("request_time",new SimpleDateFormat("yyyyMMddHHmmss").format(System.currentTimeMillis()-60*60*1000));

            String toSign = StringUtil.buildSignSrc( jsonObject);
            jsonObject.put("sign", Md5.md5Str(toSign+"&key="+md5key));

            String resParam = HttpClient.doPost(PreWithdrawDomain+"/withdraw/singleQuery", jsonObject.toJSONString());

            System.out.println(resParam);
        }

        /*
         * 余额查询
         * */
        @Test
        public void balanceQuery() throws Exception {
            JSONObject jsonObject = new JSONObject();
            //设置json数据
            jsonObject.put("mer_no",merno);
            jsonObject.put("mer_order_no","");
            jsonObject.put("order_no", "");
            jsonObject.put("request_no",System.currentTimeMillis()+"");
            jsonObject.put("request_time",new SimpleDateFormat("yyyyMMddHHmmss").format(System.currentTimeMillis()-60*60*1000));

            String toSign = StringUtil.buildSignSrc(jsonObject);
            jsonObject.put("sign", Md5.md5Str(toSign+"&key="+md5key));

            String resParam = HttpClient.doPost(PreWithdrawDomain+"/withdraw/balanceQuery", jsonObject.toJSONString());

            System.out.println(resParam);
        }

}


